(function ($, root, undefined) {
	$(function () {
		'use strict';
		// var templateUrl = object_name.templateUrl;

    var totalSeguro = $("#total_seguro");
    totalSeguro.val(0);


    // Origen
    $('#c1').change(function() { actualizar_destinos(); });

    $('body').on('change', '#c2', function() {
      // actualizar();
    });


    // Tipo de medida - Metros
    $('body').on('change', '#c5', function() {
      if($('#c5 option:selected').val() == "m") {
        $(".input-medidas").html("mt");
      }else {
        $(".input-medidas").html("cm");
      }
    });

    // $('body').on('keyup', '#c6', function() { actualizar(); }); // Alto
    // $('#c7').keyup(function() { actualizar(); }); // Ancho
    // $('#c8').keyup(function() { actualizar(); }); // Largo
    // $('#f7').keyup(function() { actualizar(); }); // cantidad
    // $('#c10').change(function() { actualizar(); }); // tipo peso
    // $('#c11').keyup(function() { actualizar(); }); // peso por pieza
    $('#costo_mercancia').keyup(function() {
      actualizar();
    });



    function validar_servicio() {
      var valor_servicio = $('input[name="tipo_servicio"]:checked').val();
      if(valor_servicio == 1) {
        $( "input[name='c6[]']" ).prop('readonly', false).val(1);
        $( "input[name='c7[]']" ).prop('readonly', false).val(1);
      }else if(valor_servicio == 2) {
        $( "input[name='c6[]']" ).prop('readonly', true).val(2.55);
        $( "input[name='c7[]']" ).prop('readonly', true).val(2.55);
      }else {
        $( "input[name='c6[]']" ).prop('readonly', true).val(2.55);
        $( "input[name='c7[]']" ).prop('readonly', false).val(1);
      }
    }
    
    
    
    $('input[name="tipo_servicio"]').click(function() {
      validar_servicio();
    });

    
    
    
      
    // Calcular costo del seguro de mercancía
    $("#costo_mercancia").prop('disabled', true).val(1000);
    $('#total_seguro').prop('disabled', true).val(10);
    $('#seguro').click(function() {
      if($('#seguro').is(':checked')) {
        $("#costo_mercancia").prop('disabled', false).val(1000);
        $('#total_seguro').val(10);
      }else {
        $("#costo_mercancia").prop('disabled', false).val(1000);
        $('#total_seguro').val(10);
      }
    });
    
    $("#costo_mercancia").focusout(function() {
      var valor = $(this).val();
      if(valor >= 1000) {
        $('#total_seguro').val(valor * 0.01);
      }else {
        $("#costo_mercancia").val(1000);
        $('#total_seguro').val(10);
      }
    });
    
    // Activar el ISR
    var isr_on = 0;
    $('#retencion').click(function() {
      if($('#retencion').is(':checked')) {
        $(".input-retencion").fadeIn();
        isr_on = 1;
      }else {
        $(".input-retencion").fadeOut();
        isr_on = 0;
      }
    });
    
    

    
    $("#enviar_cotizacion_1").prop('disabled', true);
    $("#enviar_cotizacion_2").prop('disabled', true);

    $('#acepta_terminos_1').click(function() {
      if($('#acepta_terminos_1').is(':checked')) {
        $("#enviar_cotizacion_1").prop('disabled', false);
      }else {
        $("#enviar_cotizacion_1").prop('disabled', true);
      }
    });
    
    $('#acepta_terminos').click(function() {
      if($('#acepta_terminos').is(':checked')) {
        $("#enviar_cotizacion_2").prop('disabled', false);
      }else {
        $("#enviar_cotizacion_2").prop('disabled', true);
      }
    });


    // Casilla de recolección
    $('#recoleccion_activa').click(function() {
      if($('#recoleccion_activa').is(':checked')) {
        $('#recoleccion_activa').val(1);
      }else {
        $('#recoleccion_activa').val(0);
      }
    });





    function actualizar_destinos() {
      var c1 = $('#c1 option:selected').val(); //check
      var destinos = $(".lista-destinos");
      var destinos_info = destinos.html();
      
      $.ajax({
    		url: 'https://cotizador.expressmg.com.mx/v4/include/actualizar-destinos.php',
    		type: 'GET',
    		data: { c1: c1 }
    	})
    	.done(function(data) {
    		if (data.exito) {
          destinos.prop('disabled', false).html(data.html);
    		} else {
          destinos.prop('disabled', true).html(destinos_info);
    			console.log('Intenta activar la lista de destinos en unos momentos');
    		}
    	})
    	.fail(function(xhr, ajaxOptions, thrownError) {
    		console.log("Error al activar lista de destinos");
    		console.log(xhr.statusText);
    		console.log(xhr.responseText);
    		console.log(xhr.status);
    		console.log(thrownError);
    	});
    }







    $("#calcular_todo").click(function(e) {
      e.preventDefault();
      actualizar();
    });



    function actualizar() {
      // console.log("Actualizando cotizador...");
      var form = $("#form-servicios-especializados");
       
      var origen = $('#c1 option:selected').val();
      var destino = $('#c2 option:selected').val();
      var tipo_medida = $('#c5 option:selected').val();
      var tipo_peso = $('#c10 option:selected').val();      
      var total_seguro = $('#total_seguro').val();
      var costo_mercancia = $("#costo_mercancia").val();

      $.ajax({
				url: 'https://cotizador.expressmg.com.mx/v5/include/actualizar.php',
				type: 'GET',
        data: form.serialize() + "&tiene_isr=" + isr_on + "&total_seguro=" + $('#total_seguro').val()
			})
			.done(function(data) {
        console.log(data);
				if (data.exito) {
          // $('#total').val(data.total);
          // $('#c15').val(data.c15);
          // $('#c16').val(data.c16);
          // $('#d15').val(data.d15);
          // $('#d16').val(data.d16);
          // $('#f5').val(data.f5);
          $('#recoleccion').val(data.recoleccion);
          $('#isr').val(data.isr);
          $('#retencion1').val(data.retencion1);
          $('#f9').val(numerosConComas(data.f9));
          $('#f10').val(numerosConComas(data.f10));
          // $('#iva').val(data.iva);
				} else {
					console.log('Intenta activar el cotizador en unos momentos');
				}
			})
			.fail(function(xhr, ajaxOptions, thrownError) {
				console.log("Error al activar el cotizador general");
				console.log(xhr.statusText);
				console.log(xhr.responseText);
				console.log(xhr.status);
				console.log(thrownError);
			});
    }




		function numerosConComas(x) {
			return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
		}





    // Crear inputs dinámicamente
    var campos_max = 7;   //max de 10 campos
    var x = 0;

    $('body').on('click', '#add_field', function() {
      validar_servicio();
    });
    
    
    $('#add_field').click(function(e) {
      e.preventDefault();
      if (x < campos_max) {
        validar_servicio();

        $('#listas').append(`
        <div class="row item-productos producto-${x}">              
            <div class="col-md-2 col-2">
              <label for="c8">Largo</label>
              <div class="input-group input-largo">
                <input type="text" class="form-control" id="c8" name="c8[]" value="1" placeholder="Largo" required>
                <div class="input-group-append">
                  <span class="input-group-text input-medidas">mt</span>
                </div>
              </div>
            </div>
            
            <div class="col-md-2 col-2">
              <label for="c6">Alto</label>
              <div class="input-group input-alto">
                <input type="text" class="form-control" id="c6" name="c6[]" value="1" placeholder="Alto" required>
                <div class="input-group-append">
                  <span class="input-group-text input-medidas">mt</span>
                </div>
              </div>
            </div>

            <div class="col-md-2 col-2">
              <label for="c7">Ancho</label>
              <div class="input-group input-ancho">
                <input type="text" class="form-control" id="c7" name="c7[]" value="1" placeholder="Ancho" required>
                <div class="input-group-append">
                  <span class="input-group-text input-medidas">mt</span>
                </div>
              </div>
            </div>
            
            <div class="col-md-2 col-2">
              <label for="f7">Cantidad</label>
              <div class="input-group input-ancho">
                <input type="text" class="form-control" id="f7" name="f7[]" value="1" placeholder="Cantidad" required>
                <div class="input-group-append">
                  <span class="input-group-text">pzas</span>
                </div>
              </div>
            </div>

            <div class="col-md-2 col-2">
              <label for="c11">Peso por pieza</label>
              <div class="input-group input-ancho">
                <input type="text" class="form-control" id="c11" name="c11[]" value="1" placeholder="Peso" required>
                <div class="input-group-append">
                  <span class="input-group-text input-peso">kg</span>
                </div>
              </div>
            </div>

            <br>
            <a href="#" class="btn btn-danger remover_campo">
              <i class="fa-solid fa-xmark"></i>
            </a>
          </div>
        </div>`);
        x++;
      }
    });
    
    // Eliminar bloque
    $('#listas').on("click",".remover_campo",function(e) {
      e.preventDefault();
      $(this).parent('.row').remove();
      x--;
    });


	});

})(jQuery, this);