<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Rastrea tu envío | Express MG</title>

  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" integrity="sha512-1sCRPdkRXhBV2PBLUdRb4tMg1w2YPf37qatUFeS7zlBy7jJI8Lf4VHwWfZZfpXtYSLy85pkm9GaYVYMfw5BC1A==" crossorigin="anonymous" referrerpolicy="no-referrer" />
      
  <style>
    body {
      margin-top: 50px;
    }
  </style>
</head>
<body>

  <div class="container">
    <div class="row">
      <div class="col-md-12">
        <form action="" method="POST" id="form-json">
          <div class="form-group">
            <label for="carta_porte">C</label>
            <input type="text" class="form-control" name="carta_porte" id="carta_porte">
          </div>

          <button type="submit" class="btn btn-success">
            Rastrear envío <i class="fas fa-search"></i>
          </button>
        </form>
        <br>
      </div>

      <div class="col-md-12">
        <div class="informacion_detallada"></div>
      </div>
    </div>
  </div>


  <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
  <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
  <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
  <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
  <script src="js/moment.min.js"></script>
  <script src="js/moment-with-locales.min.js"></script>
  <script src="js/jquery.json.js"></script>

  <script>
    $(document).ready(function() {
      $('#form-json').submit(function(e) {
        e.preventDefault();
        
        activar_rastreo($("#carta_porte").val());
      });
    });


    // 1475684
    // 1489742
    function activar_rastreo(carta)
    {
      var data = {
        "access" : {
          "token" : "c290537eb8da38ab0446a72db5b64ee83d17598c",
          "cat" : "api",
          "fn" : "getStatusTracking"
        },
        "data" : {
          "CartaPorte" : carta
        }
      };

      var boton = $("#form-json").find(':submit');
      boton.prop('disabled', true).html('Rastreando envío <i class="fas fa-spinner fa-spin"></i>');

      console.log(data);
        $.ajax({
          url: "https://app.trans-tec.mx/ws/integration_tracking/",
          type: 'POST',
          data: $.toJSON(data),
          contentType: "application/json"
        })
        .done(function(data) {
          // console.log(data);
          boton.prop('disabled', false).html('Rastrear envío <i class="fas fa-search"></i>');

          $.each(data.data_tracking, function(index, value) {
            moment.locale('es-mx');
            var fecha = moment(value.date).format('L LT');
            var texto = value.title != null ? value.title : value.tittle;

            $(".informacion_detallada").append(`
              <div class="card">
                <div class="card-header">
                  ${texto}
                </div>
                <div class="card-body">
                  <p class="card-text">
                    ${fecha}
                  </p>
                </div>
              </div>
              <br>
            `);
            // Will stop running after "three"
            // return (value !== 'three');
          });

          
        })
        .fail(function(xhr, ajaxOptions, thrownError) {
          console.log("Error al activar");
          console.log(xhr.statusText);
          console.log(xhr.responseText);
          console.log(xhr.status);
          console.log(thrownError);
        });
    }


  </script>

</body>
</html>





  